<?php
/**********************************************************
* Source Copyright 2014 Author                            *
* Unauthorized reproduction is not allowed                *
* Author: JPK Software Solutions Pvt. Ltd.                *
* Email: sales@visionhelpdesk.com                         *
* Owner: www.visionhelpdesk.com                           *
**********************************************************/

if(!defined('_VIS_')) die('Error: Call from undefined function');
class releases {
    var $error;
	
	//************LIST FUNCTION************************************
	function view_releases($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $object=new class_releases($database);
		
        $page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $sort_by=(isset($operation['vis_sort_by']))?$operation['vis_sort_by']:'';
        $operation['view_title']=$vis_language['TXTRELEASES'];
        $filter='';
		$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;
		
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
		$operation['filter_id']= (isset($action[4]))?$action[4]:$operation['vis_filter_id'];
        if(isset($data['vis_filter_id'])) $action[4]=$data['vis_filter_id']; 
        if(isset($operation['vis_filter_id'])) $action[4]=$operation['vis_filter_id']; 
		
		if(isset($operation['criteria']) && $operation['criteria']!='')
		{	
			$filter.=" ( ".VIS_TABLE_PREFIX."itil_releases.release_hash='".addslashes($operation['criteria'])."' OR ".VIS_TABLE_PREFIX."itil_releases.subject like '%".addslashes($operation['criteria'])."%') and ";
			$criteria = $operation['criteria'];
        }
		
		if($action[4]==13)
        {
			$filter.=VIS_TABLE_PREFIX.'itil_releases.status_id!=3 and' ;
		}
		else if($action[4]==14)
		{
			$filter.=VIS_TABLE_PREFIX.'itil_releases.status_id=1 and ';
		}
		else if($action[4]==15)
		{
			$filter.=VIS_TABLE_PREFIX.'itil_releases.status_id=3 and ';
		}
		else if($action[4]==16)
		{
			$filter.='FIND_IN_SET ("'.VIS_STAFF_ID.'", '.VIS_TABLE_PREFIX.'itil_releases.staff_id) and ';
		}
		
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)
        {
		    if($data['search_department']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_releases.department_id=".$data['search_department']." and ";
			if($data['search_priority']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_releases.priority_id=".$data['search_priority']." and ";
		    if($data['search_status']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_releases.status_id=".$data['search_status']." and ";
		    if($data['search_release_type']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_releases.release_type_id=".$data['search_release_type']." and ";
		}
		$filter=substr($filter, 0, -4);
		
		list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
        list($releases_info, $releases_details)=$object->get_releases($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $view_info['page_count']=($releases_info['total']==0)?0:ceil($releases_info['total']/$view_info['page_count']);
		$view_info['view_count']=count($view_details);
		$releases_info['releases_count']=(!$releases_details || $releases_details==-1)?0:count($releases_details);
        $releases_info['page']=$page;
		
        $database->database_disconnect();
        // Code fot api - start
        if(VIS_LOCATION_AREA==0) {
			if($releases_details!='') echo get_xml($releases_details, 'ticket');
			else echo $vis_language['MSGDATANOTFND'];
            return true;
        }
        // Code for api - end
        if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_action']) && $operation['vis_action']=='no_load')){
			ob_start();
			include(VIS_PATH_TEMPLATE.'releases_list.php');
			$releases_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select .= "<select name=\"pageing\" id=\"paging\" class=\"form-control input-sm selectpicker pull-right paging v-middle\"  onChange=\"javascript:vis_apply_filter(this.value);\">";					  
			for($i=0;$i<$view_info['page_count'];$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			
			echo json_encode(array('total_cnt'=>$releases_info['total'], 'paging' => $select, 'list'=> $releases_list));
		}else{
			include(VIS_PATH_TEMPLATE.'releases.php');
			echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"releases","vis_current_operations":"view_releases"});</script>';
		}	
        return true;
    }
	
	function get_releases_delete($operation) {
        global $vis_language;
		$message_info['vis_form_title']=$vis_language['TXTDELETERELEASE'];
		$message_info['vis_message']=$vis_language['MSGSURE'];
		$message_info['vis_event']="$('#vis_global_msg_div').visExecution('submit_form', {'vis_module': 'releases', 'vis_operation': 'update_properties', 'vis_action': 'delete', 'vis_form':'vis_releases_form', 'vis_update_id': 0 });";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	
	function delete_releases($operation) {
        global $vis_language;
        $operation['vis_current_operation']='filter_releases'; 
        $operation['vis_current_module']='releases'; 
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_releases($database);
		$sub_object=new class_subsetting($database);
		list($releases_info, $releases_details)=$object->get_releases($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$object->delete_releases($operation['vis_release_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_releases_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$releases_details[0]['subject']." Release", VIS_STAFF_ID,7, VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'", vis_filter_id: "'.$operation['vis_filter_id'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	
	function filter_releases($operation) {
		
		if(isset($operation['vis_filter_id']) && is_numeric($operation['vis_filter_id'])) $filter_id=$operation['vis_filter_id']; 
        else if(isset($operation['vis_action']) && $operation['vis_action'] != ""){
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
			$operation['filter_id']= (isset($action[4]))?$action[4]:$operation['vis_filter_id'];
			
            if(isset($action[4]) && is_numeric($action[4])) {
                $operation['vis_filter_id'] = $filter_id=$action[4];
			}
        }
        else $filter_id=16;
		
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $releases_object=new class_releases($database);   
        if(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) {
            $page=$operation['vis_page'];
            if(isset($_COOKIE['vis_filter_id_page'])) $vis_filter_id_page=unserialize($_COOKIE['vis_filter_id_page']);
            $vis_filter_id_page[$filter_id]=$page;
            setcookie('vis_filter_id_page', serialize($vis_filter_id_page));
        } else {
            $page=0;
            if(isset($_COOKIE['vis_filter_id_page'])) {
                $vis_filter_id_page=unserialize($_COOKIE['vis_filter_id_page']);
                if(isset($vis_filter_id_page[$filter_id]) && is_numeric($vis_filter_id_page[$filter_id])) $page=$vis_filter_id_page[$filter_id];
            }
        }
		
        $sort_by=(isset($operation['vis_sort_by']))?$operation['vis_sort_by']:'';
        $filter=$releases_object->get_filter($filter_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($filter_id==16) $filter['filter'].= ' and '.VIS_TABLE_PREFIX.'itil_releases.status_id!=3';
        if($filter != ""){
			if(!isset($operation['view_title']))
            $operation['view_title']=$filter['filter_name'];
            $operation['filter_id']=$filter['filter_id'];
        } else {
            $operation['vis_filter_id'] = 1;
            return $this->filter_releases($operation);
        }
        $database->database_disconnect();
		
         if($filter['filter_name']=="Search Result")
			return $this->releases_display($operation, '', '', $filter['filter'], $page, $sort_by);
        else if($filter['filter_name']!="Search Result" && $filter['filter_name']!="Releases" )
			return $this->releases_display($operation, '', '', $filter['filter'], $page, $sort_by);
        else 
			return $this->releases_display($operation, '', '', $filter['filter'], $page, $sort_by);
    }
	
	function releases_display($operation, $and_conditions, $or_conditions, $filter='', $page=0, $sort_by='') {      
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket=new class_ticket($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $object=new class_releases($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		
        if(isset($operation['vis_filter_array']) && $operation['vis_filter_array']!='')
        {
			$filter=VIS_TABLE_PREFIX.'itil_releases.release_id in ('.$operation['vis_filter_array'].')';
		}
		
		$quick_view=$object->get_releases_filter_counts('', VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
        list($releases_info, $releases_details)=$object->get_releases($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $view_info['page_count']=($releases_info['total']==0)?0:ceil($releases_info['total']/$view_info['page_count']);
		$view_info['view_count']=count($view_details);
		$view_info['view_title']=$operation['view_title'];
		$releases_info['releases_count']=(!$releases_details || $releases_details==-1)?0:count($releases_details);
        $releases_info['page']=$page;
		
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_action']) && $operation['vis_action']=='no_load')){
			ob_start();
			include(VIS_PATH_TEMPLATE.'releases_list.php');
			$releases_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select = "<select name=\"pageing\" class=\"form-control input-sm selectpicker pull-right paging v-middle\" onchange=\"vis_apply_filter(this.value, '".$operation['vis_filter_id']."');\">";					  
			for($i=0;$i<$view_info['page_count'];$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			
			echo json_encode( array('total_cnt'=>$releases_info['releases_count'], 'paging' => $select, 'list'=> $releases_list, 'filter_id'=>$operation['vis_filter_id']));
		}else{
			//--filter list data
			if(isset($operation['vis_action'])) $options=parse_form_array($operation['vis_action']);
			else $options=$operation;
			include(VIS_PATH_TEMPLATE.'releases.php');
			echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"releases","vis_current_operations":"filter_releases","vis_filter_id":"'.$operation['filter_id'].'"});</script>';
		}
        $database->database_disconnect();
        return true;
    }
		
	function update_properties($operation) {
        global $vis_language;
        $list_chk=array();
		$database=new class_database();
		global $operation_hnd;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
		$releases_object=new class_releases($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		
        if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
            $property=$operation['vis_action'];
            $list_chk[]=$operation['vis_release_id'];
            $area=0;
        } else {
            $options=parse_form_array($operation['vis_action']);
            $property=$options['action'];
            $operation['vis_action']=$property;
            foreach($options as $data=>$value) if(preg_match('/vis_global_mass_chk_[0-9]/', $data)) $list_chk[]=$value;
            $area=1;
        }
		if(isset($operation['dept']) && $operation['dept']!=''){
            $department_list=array();
            for($i=0;$i<count($operation['dept']);$i++){
                $temp=explode('-',$operation['dept'][$i]);
                $department_list[$i]=$temp[0];
            }
        }
        if(empty($list_chk)){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		
		if(isset($operation['vis_update_id']) && $operation['vis_update_id']!='') {
            if($property=='priority')
			{
				 $filter='is_enabled=1 and priority_id='.$operation['vis_update_id'];
				 $priority_department=$ticket_object->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, $filter);
				 $priority_dept_access=explode(',', $priority_department[0]['department_access']);
				 if($priority_department[0]['department_access']!=0)
				 {
					for($k=0;$k<count($department_list);$k++){
						if(!in_array($department_list[$k], $priority_dept_access)) {
							unset($list_chk[$k]);
						}
					}
				 }
			}
			if($property=='status')
			{
				 $filter='is_enabled=1 and status_id='.$operation['vis_update_id'];
				 $status_department=$ticket_object->get_status_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
				 $status_dept_access=explode(',', $status_department[0]['department_access']);
				 if($status_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $status_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
			if($property=='releasetype')
			{
				 $filter='is_enabled=1 and release_type_id='.$operation['vis_update_id'];
				 list($release_type_info, $releasetype_department)=$setting_object->get_release_type($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				 $releasetype_dept_access=explode(',', $releasetype_department[0]['department_access']);
				 if($releasetype_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $releasetype_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
                        if($property=='category')
			{
				 $filter='is_enabled=1 and category_id='.$operation['vis_update_id'];
				 list($category_info, $category_department)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,"");
				 $category_dept_access=explode(',', $category_department[0]['department_access']);
				 if($category_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $category_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
			
            $ret=$releases_object->set_release_property($property, $operation, $list_chk, VIS_STAFF_ID, VIS_LOCATION_AREA);
            for($i=0;$i<count($list_chk);$i++) {
                $operation['vis_release_id']=$list_chk[$i];
            }
            $database->database_disconnect();
			
           if(VIS_LOCATION_AREA==0) {
                echo ($ret)?'success':'error';
            }
            else {
               if(!$ret) {
                    $msg = ($property == 'department') ? $vis_language['MSGRELEASEMOVETODEPT'] : $vis_language['MSGACCSSDND'];
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$msg.'");$("[id^=\'vis_global_mass_chk_\']").attr("checked",false); </script>';
                    return false;
                }
                else {
					echo '<script>';
                    if($area==0) {
                        if($property=='delete')
                            echo "$('#vis_workpanel_div').visExecution('load_module', '".$vis_language['TXTRELEASES']."', {'vis_module':'releases', 'vis_operation':'filter_releases', 'vis_filter_id': 16});";
                        else {
                            echo ' $("#vis_details_list_'.$operation['vis_release_id'].'").visExecution("load_area",{"vis_module":"releases", "vis_operation":"get_details", "vis_action":"details", "vis_release_id":"'.$operation['vis_release_id'].'"});';
                        } 
                    }
                    else{
						if($options['vis_export_function'] == '3')
							echo "$('#vis_workpanel_div').visExecution('load_area', {'vis_module':'releases', 'vis_operation':'filter_releases', 'vis_filter_id': '".$options['vis_filter_id']."'});";
						else echo "$('#vis_workpanel_div').visExecution('load_area', {'vis_module':'releases', 'vis_operation':'filter_releases', 'vis_filter_id': '".$options['vis_filter_id']."','vis_tag':'tag'});";
					}
                    if($options['vis_export_function'] == 'view_releases') {  
					
					}
					echo '$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
                    echo '</script>';
                }
            }
            return $ret;
        }
        else {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
    }
	
	/* NEW RELEASE FIRST STEP */
	function new_release_step_one($operation) {
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket=new class_ticket($database);
		$filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
		$departments=$ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
		$departmentid = $departments[0]['department_id'];
	   
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'release_new_step_one.php');
		return true;
	}	
	
	/*VIEW NEW RELEASE FORM*/
    function new_release($operation){
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);	
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		
		if(!isset($operation['department_id'])){
			return $this->new_release_step_one($operation);
		}
	
		list($operation['domain_id'], $operation['department_id'])=explode(':', $operation['department_id']);
		$vis_department_id= $operation['department_id'];
        $domain=$operation['domain_id'];
        $vis_channel_id= $operation['channel_id'];
		
		$filter_condtn = '(department_access=0 or find_in_set('.$vis_department_id.', department_access))';
        $release_type_details=$ticket_module->get_properties('get_releasetype', '', $filter_condtn);
        $priorities=$ticket_module->get_properties('get_priorities', '', $filter_condtn);
		$status=$ticket_module->get_properties('get_status', '', $filter_condtn);
		
		$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $operation['department_id']);
		$login_staff = $staff_object->get_staff('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$location[0] = 2;
        
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	$setting_object=new class_setting($database);
        $module_setting=$setting_object->get_module_setting('domain_id='.$operation['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))';
		if(!isset($module_setting['vis_show_priority']) || $module_setting['vis_show_priority']==1 || $module_setting['vis_show_priority']==2){
			$module_setting['vis_priority']='';
			$priorities=$ticket->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))');
		}
		if(!isset($module_setting['vis_show_tickettype']) || $module_setting['vis_show_tickettype']==1 || $module_setting['vis_show_tickettype']==2){
			$module_setting['vis_tickettype']='';
			$ticket_types=$ticket->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))');
		}
		if(isset($module_setting['vis_show_level']) && ($module_setting['vis_show_level']==1 || $module_setting['vis_show_level']==2)){
			$module_setting['vis_level']='';
			list($ticket_level_count, $ticket_level_details)=$setting_object->get_ticket_level_list( $filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		}
		if(isset($module_setting['vis_show_category']) && ($module_setting['vis_show_category']==1 || $module_setting['vis_show_category']==2)){
			$module_setting['vis_category']='';
			list($ticket_cat_count,$ticket_cat_details)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		}
		if(VIS_ITIL==1){
			$location_assets=$setting_object->get_locations(" AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0 OR FIND_IN_SET(".$operation['department_id'].", ".VIS_TABLE_PREFIX."itil_location.department_access)>0)",0, -1, '', VIS_STAFF_ID);
		}

		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'release_new_step_two.php');
		echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"releases","vis_current_operations":"new_release"});</script>';
        return true;
	}
	
	/* RELEASE ADDED*/
	function open_new_release($operation) {      
        global $vis_language, $operation_hnd;
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $database=new class_database();
        if(isset($operation['vis_action']))$data=parse_form_array($operation['vis_action']); else $data=$operation;
        $release_object=new class_releases($database);
		if(!isset($data['vis_from']) || trim($data['vis_from'])==''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQFILFRMEMAIL'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQSTAFFSEMAIL'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_subject']) || trim($data['vis_subject'])==''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQSUB'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQSUB'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_description']) || trim(strip_tags($data['vis_description'],"<img>")) == ''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQFLDDESC'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		$data['vis_release_hash']=$cmdb_object->get_itil_hash($data['vis_domain'], '10', 'vis_itil_releases_prefix', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
        $data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
		$staff_info=$staff->get_staff("email='".$data['vis_from']."'", VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($staff_info==-1){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGINVFLDFRMEMAIL'];
			else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSGINVFLDFRMEMAIL'].'"); </script>';
			return false;
		}
		$data['vis_from_name'] = $staff_info[0]['first_name'].' '.$staff_info[0]['last_name'];
		$data['vis_from_email'] = $staff_info[0]['email'];
		$data['vis_from']=$staff_info[0]['staff_id'];
		$ret=$release_object->add_release($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(VIS_LOCATION_AREA==0) {
            echo (!$ret)?'error':'success';
            return $ret;
        }
		if($ret) {
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
			$mobject=new class_mail($database);	
			$data1['release_id'] = $ret['last_id'];
			$data1['vis_module']='itil_release';
			$data1['send_alert'] = true;
			$ret=$mobject->email_notify($data1, 'new_release', VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        else $data['vis_release_id']=0;
		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTALL'].'/16",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"filter_releases"});</script>';	
        return true;
    }
	
	function releases_details($operation) {
        global $vis_language;
        $database=new class_database(); 
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object=new class_staff($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		
		if(isset($operation['release_id']) && is_numeric($operation['release_id']) && !isset($operation['vis_release_id'])) $operation['vis_release_id']=$operation['release_id'];
		if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
			$action=array('', 'releases', 'releases_details', '', $operation['vis_release_id']);
		}
		else {
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
		}
		if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			$filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$action[4];
		}
		else {
			$this->error=$vis_language['MSGRELEASEIDMISS'];
			return false;
		}
        
		list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($releases_details==-1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		$releases_details=$releases_details[0];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$sett_obj=new class_setting($database);
			
		$module_setting=$sett_obj->get_module_setting('(title="vis_show_note" or title="vis_show_custom_field") and domain_id='.$releases_details['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$note_details = $problem_object->get_note($releases_details['release_id'], 5, 8, $releases_details['release_from'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_info=$staff_object->get_staff("staff_id='".$releases_details['release_from']."'", VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($releases_details['attachment_id']!=''){ 
			$attachments=$problem_object->get_problem_attachment($releases_details['attachment_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		
		include(VIS_PATH_TEMPLATE.'release_view.php');
		echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"releases","vis_current_operations":"releases_details"});</script>';
		
        return true;
    }
	
	function get_release_properties($operation){
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
        $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
        list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$releases_details=$releases_details[0];
		$database->database_disconnect();
        $message_info['release_id']=(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id']))?$operation['vis_release_id']:0;
        $message_info['staff_id']=(isset($operation['vis_staff_id']) && is_numeric($operation['vis_staff_id']))?$operation['vis_staff_id']:0;
        include(VIS_PATH_TEMPLATE.'release_staff_properties.php');
        return true;
    }
	
	function update_release_staff_properties($operation) {
        $data=parse_form_array($operation['vis_action']);
		global $vis_language;
        if(isset($data['vis_email']) || trim($data['vis_email'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_email']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		if(!isset($data['vis_subject']) || trim($data['vis_subject'])==''){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQSUB'].'"); </script>';
            return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object = new class_staff($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
        $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$data['vis_release_id'];
        list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($releases_details==-1) return false;
        $releases_details=$releases_details[0];
		$filter =' email="'.$data['vis_email'].'"';
        $staff=$staff_object->get_staff($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($staff==-1) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGEMAILMISS'].'"); </script>';
            return false;
        }
        else {
			$data['staff_id']=$staff[0]['staff_id'];
			$ret=$release_object->update_release_staff($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
       
        $database->database_disconnect();
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $(".modal").modal("toggle"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"releases", "vis_operation":"releases_details", "vis_release_id":'.$data['vis_release_id'].'});  $("#vis_details_list_'.$data['vis_release_id'].'").visExecution("load_area",{"vis_module":"releases", "vis_operation":"get_details", "vis_release_id":'.$data['vis_release_id'].', "vis_action":"details"});set_active_tab("release_details"); </script>';
        return true;
    }
	
	function new_note($operation){
        $message_info['release_id']=(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id']))?$operation['vis_release_id']:0;
        $message_info['staff_id']=(isset($operation['vis_staff_id']) && is_numeric($operation['vis_staff_id']))?$operation['vis_staff_id']:0;
        include(VIS_PATH_TEMPLATE.'release_note.php');
		return true;
    }
	
	function add_note($operation) {
        global $vis_language, $operation_hnd;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        if(trim($data['vis_note'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");</script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        $data['vis_note']=nl2br($data['vis_note']);
        $result = $release_object->add_note($data,5,8, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $data=array_merge($data, $operation);
        if(VIS_LOCATION_AREA==0) {
            echo ($result)?'success':'error';
        }
        else {
            if($result){
			    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
                $sett_obj=new class_setting($database);
                if(VIS_GAMIFICATION_ACCESS == 1) 
                {
                     include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
                     $staff=new class_staff($database);
                     $staff_info=$staff->get_staff('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
                     $points = $sett_obj->calculate_points($staff_info[0],7,IS_STAFF_ID,VIS_LOCATION_AREA); 
                }
				$module_setting=$sett_obj->get_module_setting('title="vis_show_note" and domain_id='.$data['vis_domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA); 
				$note_details=(VIS_NOTE_ACCESS==0)?-1:$problem_object->get_note($data['vis_release_id'], 3,6, $data['vis_staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$(".modal").modal("toggle");';
				$active_tab="";
				
					$active_tab="notes";
					echo '$("#vis_details_list_'.$data['vis_release_id'].'").visExecution("load_area", {"vis_module":"releases", "vis_operation":"get_details", "vis_action":"notes", "vis_release_id":'.$data['vis_release_id'].',"vis_client_id":'.$data['vis_staff_id'].',"vis_domain_id":'.$data['vis_domain_id'].'});';
				
				echo 'set_active_tab("'.$active_tab.'");</script>';
            }
            else{
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
            }
        }
        return $result;
        $database->database_disconnect();
    }
	
	function confirm_delete_note($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETENOTE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'releases', 'vis_operation':'delete_note', 'vis_remark_id':".$operation['vis_remark_id'].", 'vis_release_id':".$operation['vis_release_id']."});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

    function delete_note($operation) {
        global $vis_language;
        $database = new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object = new class_problem($database);
        $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$data['vis_release_id'];
        list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $releases_details=$releases_details[0];
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		
        $result = $problem_object->delete_note($operation['vis_remark_id'],8, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $note_details = $problem_object->get_note($releases_details['release_id'], 5, 8, $releases_details['release_from'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $note_count=count($note_details);
	   
        $database->database_disconnect();
        
		if($result) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			if($note_count==0)
			{
				echo '$("#vis_workpanel_div").visExecution("load_area",{"vis_module":"releases", "vis_operation":"releases_details", "vis_release_id":"'.$operation['vis_release_id'].'"});</script>';
			}
			else
			{
				echo '$("#release_note_'.$operation['vis_remark_id'].'").remove();';
				echo 'if(!$("#release_details.active").length && $("[id^=\'release_note_\']:first").hasClass("m-t-sm")) $("[id^=\'release_note_\']:first").removeClass("m-t-sm");</script>';
			}
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        
        return $result;
    }
	
	function release_description_edit($operation){
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
        $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
        list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $releases_details=$releases_details[0];
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) {  	
			$releases_details['description'] = get_plain_text($releases_details['description']);
		}
        include(VIS_PATH_TEMPLATE.'release_description_edit.php');
        return true;
    }
	
	function update_release_description($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
        if(!isset($data['vis_release_desc']) ||  trim(strip_tags($data['vis_release_desc'],"<img>"))==''){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR == 0) 
        $data['vis_release_desc'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_release_desc']);
		$result=$release_object->update_release_description($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$result)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        else 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_release_post_content_text_'.$data['vis_release_id'].'").show(); $("#vis_release_post_content_edit_'.$data['vis_release_id'].'").hide(); $("#vis_release_post_content_text_'.$data['vis_release_id'].'").html("'.$data['vis_release_desc'].'"); </script>';
        return $result;
    }
	
	function release_analysis_form($operation) {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
        list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $releases_details=$releases_details[0];
		$attachments=-1;
		if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR == 0) {  	
			$releases_details['buildplan']=get_plain_text($releases_details['buildplan']);
			$releases_details['testplan']=get_plain_text($releases_details['testplan']);
		}
		if($operation['vis_analysis_type']=='buildplan'){
			if($releases_details['buildplan_attachment']!=''){ 
				$attachments=$problem_object->get_problem_attachment($releases_details['buildplan_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		if($operation['vis_analysis_type']=='testplan'){
			if($releases_details['testplan_attachment']!=''){ 
				$attachments=$problem_object->get_problem_attachment($releases_details['testplan_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'release_analysis_update.php');
        return true;
    }
	
	function update_release_analysis($operation) {
        global $vis_language;
		$database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_release_plan_desc']) ||  trim(strip_tags($data['vis_release_plan_desc'],"<img>"))==''){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR == 0) 
        $data['vis_release_plan_desc'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_release_plan_desc']);
		$data['analysis_type'] = $operation['vis_analysis_type'];
		$result=$release_object->update_release_analysis($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$result)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        else {
            echo "<script>$('#vis_release_analysis_show_".$data['vis_release_id']."').visExecution('load_area',{'vis_module':'releases', 'vis_operation':'get_details','vis_action': 'analysis', 'vis_analysis_type': '".$data['analysis_type']."', 'vis_release_id':".$data['vis_release_id']."});</script>";
		}
        return $result;
    }
	
	function confirm_delete_analysis($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'releases', 'vis_operation':'delete_analysis', 'vis_release_id':".$operation['vis_release_id'].", 'vis_analysis_type':'".$operation['vis_analysis_type']."'});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	
	function delete_analysis($operation) {
        global $vis_language;
		$database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
        $result = $release_object->delete_analysis($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($result) {
			echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_release_analysis_show_".$operation['vis_release_id']."').visExecution('load_area',{'vis_module':'releases', 'vis_operation':'get_details','vis_action': 'analysis', 'vis_analysis_type': '".$operation['vis_analysis_type']."', 'vis_release_id':".$operation['vis_release_id']."});</script>";
			
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        return $result;
    }
	
	function get_details($operation) {
        global $vis_language;
		switch($operation['vis_action']) {
            case 'details':
                if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
                    $ticket_object=new class_ticket($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
                    $release_object=new class_releases($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
                    $changes_object=new class_changes($database);
					
                    $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
					list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($releases_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_release_div"); </script>';
                        return false;
                    }
					$releases_details=$releases_details[0];
					$filter = " attach_type=5 AND parent_id=".$releases_details['release_id'];
					list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter = " attach_type=3 AND child_id=".$releases_details['release_id'];
					list($total_changes, $attached_changes)=$release_object->get_changes_attachedto_release($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter = " attach_type=11 AND parent_id=".$releases_details['release_id'];
					list($total_task, $attached_task)=$release_object->get_task_attachedto_release($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'department.department_id='.$releases_details['department_id'].' and '.VIS_TABLE_PREFIX.'domain.domain_id='.$releases_details['domain_id'].' and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
				    $departments=$ticket_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
        			$owner_details=-1;
                    if($releases_details['staff_id']!='' && $releases_details['staff_id']!='0'){
						$owner_details=$problem_object->get_problem_owner($releases_details['staff_id']);
					}
                    $filter = " aprovals_type=1 AND ".VIS_TABLE_PREFIX."itil_changes_aprovals.is_enabled=1 AND parent_id=".$releases_details['release_id'];
					list($total_aprovals, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);

					$filter = " aprovals_type=1 AND ".VIS_TABLE_PREFIX."itil_changes_aprovals.is_enabled=1 AND ".VIS_TABLE_PREFIX."itil_changes_aprovals.staff_id=".VIS_STAFF_ID." AND parent_id=".$releases_details['release_id'];
					list($single_aprovals, $single_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter= ' is_enabled=1 AND parent_id='.$releases_details['release_id'];
					$aprovals_status=$changes_object->get_aprovals_status($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, 1);
					
                   include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	           $setting_object=new class_setting($database);
                   $module_setting=$setting_object->get_module_setting('domain_id='.$releases_details['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
                   $filter = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))';
		   if(isset($module_setting['vis_show_category']) && ($module_setting['vis_show_category']==1 || $module_setting['vis_show_category']==2)){
			$module_setting['vis_category']='';
			list($ticket_cat_count,$ticket_cat_details)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		   }
		   if(VIS_ITIL==1){
			$location_assets=$setting_object->get_locations(" AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0 OR FIND_IN_SET(".$operation['department_id'].", ".VIS_TABLE_PREFIX."itil_location.department_access)>0)",0, -1, '', VIS_STAFF_ID);
		   }

                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'release_details.php');
					if(isset($operation['open_aprovals']) && $operation['open_aprovals']=='yes'){
						echo "<script>$('#vis_show_attach_all_".$releases_details['release_id']."').visExecution('load_operations',{'vis_module':'releases', 'vis_operation':'get_details', 'vis_action':'aprovals', 'vis_release_id':'".$releases_details['release_id']."'});</script>";
					}
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRELEASEIDMISS'].'"); </script>';
                    return false;
                }
            break;
            case 'audit_log':
                if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
                    $object=new class_ticket($database);
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');  
                    $staff=new class_staff($database);
					list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
                    $page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;     
					$limit=($page*$view_info['page_count']).','.$view_info['page_count'];	
                    list($audit_log_info, $audit_log)=$object->audit_log($operation['vis_release_id'], $limit, $page, VIS_STAFF_ID, VIS_LOCATION_AREA, 3);
                    $view_info['page_count']=($audit_log_info['total']==0)?0:ceil($audit_log_info['total']/$view_info['page_count']);
					$audit_log_info['page']=$page;
					$view_info['view_count']=count($view_details);
                    $audit_count=($audit_log==-1)?0:count($audit_log);
                    for($i=0 ; $i<$audit_count ; $i++)
                    {
						switch($audit_log[$i]['operation_id']) {
							case '0':
								include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
								$object=new class_setting($database);
								$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
								$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
								$audit_log[$i]['audit_log_operation']=$vis_language['MSGNEWRELEASE'].' by '.$staff_name;
							break;
							case '1':
									include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
									$object=new class_setting($database);
									$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
									$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTRPLD'].' by '.$staff_name;
							break;
							case '2':
								$audit_log[$i]['audit_log_operation'] = 'Status updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
							break;	
							case '3':
								$audit_log[$i]['audit_log_operation'] = 'Priority updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
							break;
							case '4':
								$audit_log[$i]['audit_log_operation'] = 'Department changed from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
							break;
							case '5':
								$audit_log[$i]['audit_log_operation'] = 'Release type changed from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
							break;
							case '6':
								$audit_log[$i]['audit_log_operation'] = 'Release properties updated';
							break;
							case '7':
								include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
								$object=new class_setting($database);
								$staff_new_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['new_info'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
								$new_info =  $staff_new_info[1][0]['first_name'].' '.$staff_new_info[1][0]['last_name'];
								if($audit_log[$i]['new_info']!=0 && $staff_new_info[1]!=-1)
									$audit_log[$i]['audit_log_operation'] = 'Release assigned to '. $new_info;
								elseif($audit_log[$i]['new_info']==0 && $audit_log[$i]['old_info']>0){ 
									$staff_old_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['old_info'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
									$old_info =  $staff_old_info[1][0]['first_name'].' '.$staff_old_info[1][0]['last_name'];
									$audit_log[$i]['audit_log_operation'] = 'Release unassigned From '. $old_info;
								}
								else
									$audit_log[$i]['audit_log_operation'] = 'Release assigned to Nobody';
							break;
							case '8':
								include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
								$object=new class_setting($database);
								$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
								$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
								$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTTRSH'] .' by '.$staff_name;
							break;
							case '9':
								$audit_log[$i]['audit_log_operation'] = 'Release description updated';
							break;
							case '10':
								$audit_log[$i]['audit_log_operation'] = $audit_log[$i]['old_info'];
							break;
							case '11':
								$audit_log[$i]['audit_log_operation'] = 'Planned start date changed from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
							break;
							case '12':
								$audit_log[$i]['audit_log_operation'] = 'Planned end date changed from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
							break;
							case '16':
								$audit_log[$i]['audit_log_operation'] = 'Linked CI '. $audit_log[$i]['old_info'];
							break;
							case '17':
								$audit_log[$i]['audit_log_operation'] = 'Linked changes '. $audit_log[$i]['old_info'];
							break;
							case '18':
								$audit_log[$i]['audit_log_operation'] = 'Linked task '. $audit_log[$i]['old_info'];
							break;
							case '20':
								$audit_log[$i]['audit_log_operation'] = 'Detach CI '. $audit_log[$i]['old_info'];
							break;
							case '21':
								$audit_log[$i]['audit_log_operation'] = 'Detach changes '. $audit_log[$i]['old_info'];
							break;
							case '22':
								$audit_log[$i]['audit_log_operation'] = 'Detach task '. $audit_log[$i]['old_info'];
							break;
							case '23':
								$audit_log[$i]['audit_log_operation'] = 'Send approval request to '. $audit_log[$i]['old_info'];
								break;
							case '24':
								$audit_log[$i]['audit_log_operation'] = $audit_log[$i]['old_info'].' approval';
								break;
							case '25':
								$audit_log[$i]['audit_log_operation'] = 'Send approval reminder to '. $audit_log[$i]['old_info'];
								break;
                                                        case '46':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
								case '47':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETSUBCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
								case '48':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETITEMCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
								case '49':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGITILLOCATIONCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;

						}
					}
                    $database->database_disconnect();
                    if(VIS_LOCATION_AREA==0) {
                        echo get_xml($audit_log, 'audit_log');
                        return true;
                    }
                    else {
                        include_once(VIS_PATH_TEMPLATE.'release_audit_log.php');
                        return true;
                    }
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRELEASEIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'notes':
				if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
                    $database=new class_database();
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
					$sett_obj=new class_setting($database);
                    $module_setting=$sett_obj->get_module_setting('title="vis_show_note" and domain_id='.$operation['vis_domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA); 
					$note_details=(VIS_NOTE_ACCESS==0)?-1:$problem_object->get_note($operation['vis_release_id'], 5,8, $operation['vis_client_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
					include(VIS_PATH_TEMPLATE."release_note_details.php");
					return true;
				}
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRELEASEIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'analysis':
                if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
                    $release_object=new class_releases($database);
                    $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
					list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($releases_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'");</script>';
                        return false;
                    }
					$releases_details=$releases_details[0];$attachments=-1;
					if($operation['vis_analysis_type']=='buildplan'){
						if($releases_details['buildplan_attachment']!=''){ 
							$attachments=$problem_object->get_problem_attachment($releases_details['buildplan_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
						}
					}
					if($operation['vis_analysis_type']=='testplan'){
						if($releases_details['testplan_attachment']!=''){ 
							$attachments=$problem_object->get_problem_attachment($releases_details['testplan_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
						}
					}
					$database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'release_analysis_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRELEASEIDMISS'].'"); </script>';
                    return false;
                }
			case 'attach_ci':
                if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
                    $release_object=new class_releases($database);
                    $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
					list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($releases_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_release_div"); </script>';
                        return false;
                    }
					$releases_details=$releases_details[0];
					$filter = " attach_type=5 AND parent_id=".$releases_details['release_id'];
					list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);                                              
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'release_attach_ci_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRELEASEIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_changes':
                if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
                    $database=new class_database();
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
                    $release_object=new class_releases($database);
                    $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
					list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($releases_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$releases_details=$releases_details[0];
					$filter = " attach_type=3 AND child_id=".$releases_details['release_id'];
					list($total_changes, $attached_changes)=$release_object->get_changes_attachedto_release($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'release_attached_changes_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRELEASEIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_task':
                if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
                    $database=new class_database();
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
                    $release_object=new class_releases($database);
                    $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
					list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($releases_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_release_div"); </script>';
                        return false;
                    }
					$releases_details=$releases_details[0];
					$filter = " attach_type=11 AND ".VIS_TABLE_PREFIX."itil_relation.parent_id=".$releases_details['release_id'];
					list($total_task, $attached_task)=$release_object->get_task_attachedto_release($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'release_attached_task_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRELEASEIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'aprovals':
                if(isset($operation['vis_release_id']) && is_numeric($operation['vis_release_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
                    $changes_object=new class_changes($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
                    $release_object=new class_releases($database);
                    $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
					list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    if($releases_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRELEASEIDMISS'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					
					$releases_details=$releases_details[0];
					$filter = " aprovals_type=1 AND ".VIS_TABLE_PREFIX."itil_changes_aprovals.is_enabled=1 AND parent_id=".$releases_details['release_id'];
					list($total_aprovals, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter2 = " aprovals_type=1 AND remark!='' AND parent_id=".$releases_details['release_id'];
					list($total_remark, $remark_details)=$changes_object->get_aprovals($filter2, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'release_aprovals_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
        }
        if(VIS_LOCATION_AREA==2) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVOPT'].' '.$operation['vis_action'].'"); </script>';
        else echo 'error';
        return false;
    }
	
	function attach_release_ci($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		
		if(isset($operation['vis_attach_ci']) && $operation['vis_attach_ci']=='success'){
			$data=parse_form_array($operation['vis_action']);
			$flag=0;
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=5;
				$data['vis_parent_id']=$data['vis_release_id'];
				$filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$data['vis_release_id'];
				list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_attach_count'];$i++){
					
					if(isset($data['vis_attach_id_'.$i])){
						$flag=1;
						$data['vis_child_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=5 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						$release_object->add_audit_log($releases_details[0], 16, $attached_ci[0]['name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='release'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_release_id']."').visExecution('load_operations',{'vis_module':'releases', 'vis_operation':'get_details', 'vis_action':'details', 'vis_release_id':'".$data['vis_release_id']."' }); set_active_tab('release_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
			$department_id=0;
			if(isset($operation['vis_department'])) $department_id=$operation['vis_department'];
			$filter = " and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR FIND_IN_SET($department_id, ".VIS_TABLE_PREFIX."itil_configuration_item.department_access)>0)";
			$confi_item_details=$setting_object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);
			
			//$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'release_attach_ci.php');
		}
        return true;
	}
	
	function confirm_detach_ci($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDETACH'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'releases', 'vis_operation':'detach_ci', 'vis_attach_type':'".$operation['vis_attach_type']."', 'vis_detach_for':'".$operation['vis_detach_for']."', 'vis_child_id':".$operation['vis_child_id'].", 'vis_parent_id':".$operation['vis_parent_id']."});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function detach_ci($operation) {
        global $vis_language;
		$database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		
        $result = $release_object->detach_ci($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($result) {
			if($operation['vis_detach_for']=='release'){
				echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$operation['vis_parent_id']."').visExecution('load_operations',{'vis_module':'releases', 'vis_operation':'get_details', 'vis_action':'details', 'vis_release_id':'".$operation['vis_parent_id']."' }); set_active_tab('release_details');</script>";
			}
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        return $result;
    }
	
	function attach_task_to_release($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		
		if(isset($operation['vis_attach_task']) && $operation['vis_attach_task']=='success'){
			$data=parse_form_array($operation['vis_action']);
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=11;
				$data['vis_parent_id']=$data['vis_release_id'];
				$filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$data['vis_release_id'];
				list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				for($i=0;$i<$data['total_attach_count'];$i++){
					
					if(isset($data['vis_attach_id_'.$i])){
						$data['vis_child_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=11 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_task, $attached_task)=$release_object->get_task_attachedto_release($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						$release_object->add_audit_log($releases_details[0], 18, $attached_task[0]['task_title'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='release'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_release_id']."').visExecution('load_operations',{'vis_module':'releases', 'vis_operation':'get_details', 'vis_action':'details', 'vis_release_id':'".$data['vis_release_id']."' }); set_active_tab('release_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
			$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'release_attached_task.php');
		}
        return true;
	}
	
	function attach_changes_to_release($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		
		if(isset($operation['vis_attach_changes']) && $operation['vis_attach_changes']=='success'){
			$data=parse_form_array($operation['vis_action']);
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=3;
				$data['vis_child_id']=$data['vis_release_id'];
				$filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$data['vis_release_id'];
				list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				for($i=0;$i<$data['total_attach_count'];$i++){
					if(isset($data['vis_attach_id_'.$i])){
						$data['vis_parent_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=3 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_changes, $attached_changes)=$release_object->get_changes_attachedto_release($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$release_object->add_audit_log($releases_details[0], 17, $attached_changes[0]['changes_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='release'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_release_id']."').visExecution('load_operations',{'vis_module':'releases', 'vis_operation':'get_details', 'vis_action':'details', 'vis_release_id':'".$data['vis_release_id']."' }); set_active_tab('release_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
			$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'release_attached_changes.php');
		}
        return true;
	}
	
	function get_changes_list($operation){
		global $vis_language;
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		$filter = '';
		$filter .= VIS_TABLE_PREFIX.'itil_changes.domain_id='.$operation['vis_domain_id']." AND ";
		
		if($operation['attached_id']!=""){
			$selected_change=explode(',', $operation['attached_id']);
			for($i=0;$i<count($selected_change)-1;$i++){
				$filter .= ' '.VIS_TABLE_PREFIX.'itil_changes.changes_id!='.$selected_change[$i]." AND ";
			}
		}
		$filter=substr($filter, 0, -4);
		
		if(isset($operation['vis_filter']) && $operation['vis_filter']!=''){
			if($filter!=''){$filter .= ' AND ';}
			$filter .= VIS_TABLE_PREFIX."itil_changes.subject like '%".addslashes($operation['vis_filter'])."%'";
		}
	    list($changes_info, $changes_details)=$changes_object->get_changes($filter, '50', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $tbl_data='';
		if($changes_details!=-1){
			$tbl_data .= '<table class="table table-hover b-t b-light m-b-none" id="table_change_relation">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTNAME'].'</th>
										<th>'.$vis_language['TXTDEPARTMENT'].'</th>
										<th>'.$vis_language['TXTSTATUS'].'</th>						
									</tr>
								</thead>';
			
			for($i=0;$i<count($changes_details);$i++){
				$tbl_data.='<tr>';
				$tbl_data.='<td><label class="checkbox m-n i-checks"><input type="checkbox" name="vis_attach_id_'.$i.'" id="vis_attach_id_'.$i.'" value="'.$changes_details[$i]['changes_id'].'" /><i></i></label></td>';
				
				$tbl_data.='<td>'.$changes_details[$i]['subject'].'</td><td>'.$changes_details[0]['department_name'].'</td><td>'.$changes_details[$i]['status_name'].'</td></tr>';
			}
		}
		if($tbl_data==''){
			$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
			$tbl_data .='<input type="hidden" name="total_attach_count" id="total_attach_count" value="0">';
		}else{
			$tbl_data .='</table><input type="hidden" name="total_attach_count" id="total_attach_count" value="'.count($changes_details).'">';
			$tbl_data .= '</table><script type="application/javascript">$(document).ready(function() {$("#table_change_relation").dataTable({ "sScrollY":  ( 0.6 * $(window).height() ),"bPaginate": false, "bJQueryUI": true, "bScrollCollapse": true, "bAutoWidth": "90%", "scrollX": true, "sScrollXInner": "100%","bFilter": false,"bInfo": false,"ordering": false});});</script>';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	function send_aprovals($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
		$mobject=new class_mail($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		
		if(isset($operation['vis_send_request']) && $operation['vis_send_request']=='success'){
			$data=parse_form_array($operation['vis_action']);

			if(($data['total_group']>0) && $data['member']=='team')
			{   $staffid_in_group=array();
				 $groupid=array();
				 $staffid_bygroup_details=array();
				 $filter_data=array();
				 $iddata=array();
				 
					$query_string="";
					$grpid=array();
					for($i=0;$i<$data['total_group'];$i++){
					 if(isset($data['vis_group_id_'.$i])){
						$grpid[$i]=$data['vis_group_id_'.$i];
					 }	
					}
					
					$group_count=count($grpid);
					
						for($i=0;$i<$data['total_group'];$i++){
					 if($group_count>1){					
						if(isset($data['vis_group_id_'.$i])){
							if($i==($group_count-1)){ 
								$query_string[]=$data['vis_group_id_'.$i];
							}else{
							$query_string[]=$data['vis_group_id_'.$i];
							}
						}
						}else{
							if(isset($data['vis_group_id_'.$i])){
							$query_string[]=$data['vis_group_id_'.$i];
							}
						}	
					}
					$query_filter=VIS_TABLE_PREFIX.'staff.is_enabled=1 and '.VIS_TABLE_PREFIX.'staff.group_id in ('.implode(',',$query_string).') and '.VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_dept_id'];
					//$query_filter=VIS_TABLE_PREFIX.'staff.is_enabled=1 and '.VIS_TABLE_PREFIX.'staff.group_id in ('.implode(',',$query_string).')';
					//THIS ONE FOR EMPTY GRPS
					list($staffid_bygroup_details,$emptygroup)=$staff_object->get_staffid_in_group($query_filter, VIS_STAFF_ID, VIS_LOCATION_AREA); 
					if(count($query_string)>count($emptygroup)){
						$totals=count($query_string);
					}else{
						$totals=count($emptygroup);
					}
					$empty_groups=array();
					
					for($i=0;$i<$totals;$i++){
						for($j=0;$j<count($emptygroup);$j++){							
							if($query_string[$i]==$emptygroup[$j]['group_id']){
								$empty_groups[]=$emptygroup[$j]['group_id'];
							}else{}
						}
					}
					
					$ids=implode(',',$empty_groups);
					$staffgroup_list = $staff_object->get_staff_group('is_enabled=1 and group_id in('.$ids.')',VIS_STAFF_ID, VIS_LOCATION_AREA);
					for($i=0;$i<count($staffgroup_list);$i++){
						if(!empty($staffgroup_list[$i]['group_name'])){
										$teamarray[$i]=$staffgroup_list[$i]['group_name'];
								}
					}
					$team_names=implode(',',$teamarray);
					$team_names="No staff in ".$team_names." team";
					
					if(count($teamarray)>0){					
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$team_names."')</script>";
						return false;
					}
					//THIS ONE FOR EMPTY GRPS ENDS
				
				$data['vis_parent_id']=$data['vis_release_id'];
				$filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$data['vis_release_id'];
				list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_staff'];$i++){
					
					if(isset($staffid_bygroup_details[$i]['staff_id'])){
						
						$data['vis_staff_id']=$staffid_bygroup_details[$i]['staff_id'];
						$filter = VIS_TABLE_PREFIX.'itil_changes_aprovals.parent_id='.$data['vis_parent_id'].' AND aprovals_type=1 AND '.VIS_TABLE_PREFIX.'itil_changes_aprovals.staff_id='.$data['vis_staff_id'];
						list($aprovals_info, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
						if($aprovals_details !=-1){
							$filter =' parent_id='.$data['vis_parent_id'].' AND staff_id='.$data['vis_staff_id'];
							$ret=$changes_object->disabled_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,1);
						}
						$ret=$changes_object->add_aprovals($data,VIS_STAFF_ID, VIS_LOCATION_AREA,1);
						
						$staff_list = $staff_object->get_staff('is_enabled=1 and staff_id='.$data['vis_staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
												
						$data1['releases_name']=$releases_details[0]['subject'];
						$data1['domain_id']=$releases_details[0]['domain_id'];
						$data1['release_hash']=$releases_details[0]['release_hash'];
						$data1['staff']=$staff_list[0];
						$data1['template_id']=19;
						
						$data1['vis_module']='releases';
						$data1['release_id']=$data['vis_release_id'];
						$rert=$mobject->email_notify($data1, 'releases_aproval_mail', VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$release_object->add_audit_log($releases_details[0], 23, $staff_list[0]['first_name'].' '.$staff_list[0]['last_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_release_id']."').visExecution('load_operations',{'vis_module':'releases', 'vis_operation':'get_details', 'vis_action':'details', 'vis_release_id':'".$data['vis_release_id']."', 'open_aprovals':'yes' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
				}
				
			}
            //////////////////////////////			
			elseif($data['total_staff']>0){
				
				$data['vis_parent_id']=$data['vis_release_id'];
				$filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$data['vis_release_id'];
				list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_staff'];$i++){
					
					if(isset($data['vis_staff_id_'.$i])){
						
						$data['vis_staff_id']=$data['vis_staff_id_'.$i];
						$filter = VIS_TABLE_PREFIX.'itil_changes_aprovals.parent_id='.$data['vis_parent_id'].' AND aprovals_type=1 AND '.VIS_TABLE_PREFIX.'itil_changes_aprovals.staff_id='.$data['vis_staff_id'];
						list($aprovals_info, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
						if($aprovals_details !=-1){
							$filter =' parent_id='.$data['vis_parent_id'].' AND staff_id='.$data['vis_staff_id'];
							$ret=$changes_object->disabled_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,1);
						}
						$ret=$changes_object->add_aprovals($data,VIS_STAFF_ID, VIS_LOCATION_AREA,1);
						
						$staff_list = $staff_object->get_staff('is_enabled=1 and staff_id='.$data['vis_staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
												
						$data1['releases_name']=$releases_details[0]['subject'];
						$data1['domain_id']=$releases_details[0]['domain_id'];
						$data1['release_hash']=$releases_details[0]['release_hash'];
						$data1['staff']=$staff_list[0];
						$data1['template_id']=19;
						
						$data1['vis_module']='releases';
						$data1['release_id']=$data['vis_release_id'];
						$rert=$mobject->email_notify($data1, 'releases_aproval_mail', VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$release_object->add_audit_log($releases_details[0], 23, $staff_list[0]['first_name'].' '.$staff_list[0]['last_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_release_id']."').visExecution('load_operations',{'vis_module':'releases', 'vis_operation':'get_details', 'vis_action':'details', 'vis_release_id':'".$data['vis_release_id']."', 'open_aprovals':'yes' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
				}
			}
		}
		else{
			$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $operation['vis_dept_id']);
			$staffgroup_list = $staff_object->get_staff_group('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'releases_sendaprovals_request.php');
		}
        return true;
	}
	
	function change_aprove_status($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		$changes_object=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
				
		$filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
		list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				
		$ret=$changes_object->update_aprove_status($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
		}else{
		
			$status = $operation['status'];
			$status = ($status==1)? 'Aproved' : (($status==2)? 'Canceled' : 'Rejected');
			$release_object->add_audit_log($releases_details[0], 24, $status, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
	
		$database->database_disconnect();
		return $ret;
		
	}
	function reject_aprovals($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		$changes_object=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
			
		if(isset($operation['vis_reject']) && $operation['vis_reject']=='success'){
			$data=parse_form_array($operation['vis_action']);
			if(trim($data['vis_remark'])==''){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
				return false;
			}
			$data['vis_changes_id'] =$data['vis_release_id'];	
			$ret=$changes_object->update_aprove_remark($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if(!$ret){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
				return false;
			}else{
				echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_release_id']."').visExecution('load_operations',{'vis_module':'releases', 'vis_operation':'get_details', 'vis_action':'details', 'vis_release_id':'".$data['vis_release_id']."', 'open_aprovals':'yes'}); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
			}
		}
		else{
			include(VIS_PATH_TEMPLATE.'release_remark.php');
		}
		return true;
	}
	function send_aprove_reminder($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		$changes_object=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
		$mobject=new class_mail($database);	
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		$ret = -1;
		
		$filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
		list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($releases_details!=-1){
			
			$filter = VIS_TABLE_PREFIX.'itil_changes_aprovals.parent_id='.$operation['vis_release_id'].' AND aprovals_type=1 AND '.VIS_TABLE_PREFIX.'itil_changes_aprovals.staff_id='.$operation['staff_id'].' AND '.VIS_TABLE_PREFIX.'itil_changes_aprovals.aprovals_id='.$operation['aprove_id'];
			list($aprovals_info, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			
			if($aprovals_details !=-1){			
				$staff_list = $staff_object->get_staff('is_enabled=1 and staff_id='.$operation['staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
				if($staff_list!=-1){
					
					$data1['releases_name']=$releases_details[0]['subject'];
					$data1['domain_id']=$releases_details[0]['domain_id'];
					$data1['release_hash']=$releases_details[0]['release_hash'];
					$data1['staff']=$staff_list[0];
					$data1['template_id']=19;
					
					$data1['vis_module']='releases';
					$data1['release_id']=$releases_details[0]['release_id'];
					$rert=$mobject->email_notify($data1, 'releases_aproval_mail', VIS_STAFF_ID, VIS_LOCATION_AREA);			
					$release_object->add_audit_log($releases_details[0], 25, $staff_list[0]['first_name'].' '.$staff_list[0]['last_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
				}	
			}
		}
		return $ret;
	}
	
	function load_inline_images($operation) {
		global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object = new class_releases($database);
        $filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_post_id'];
        list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($operation['vis_type']=='desc')
			$content=stripslashes($releases_details[0]['description']);
		elseif($operation['vis_type']=='buildplan')
			$content=stripslashes($releases_details[0]['buildplan']);
		elseif($operation['vis_type']=='testplan')
			$content=stripslashes($releases_details[0]['testplan']);
			
        if($operation['vis_display']){ 
			echo json_encode( array('vis_post_content_html' => $content) );
        }else  {
			echo json_encode( array('vis_post_content_html' => preg_replace("/<img[^>]+\>/i", " ", $content)) );
		}
		
        $database->database_disconnect();
	}
	function get_releasetype_list($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$vis_department_id= $operation['department_id'];
		$filter_condtn = '(department_access=0 or department_access in ('.$vis_department_id.'))';
		$release_type_details=$ticket_module->get_properties('get_releasetype', '', $filter_condtn);	
		$database->database_disconnect();
		if($release_type_details!='')
        echo get_xml($release_type_details, 'releasetype');
        else echo $vis_language['MSGDATANOTFND'];
        return true;
	}
}
?>
